// 
//  Copyright 2003 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG, OCP Transaction Level Layer-1
//       Author : Norman Weyrich, Synopsys Inc., weyrich@synopsys.com
//                Anssi Haverinen, Nokia Inc., anssi.haverinen@nokia.com
//         Date : 02/15/2003
//
//		Modified by: Stephane Guntz, Prosilog, guntz@prosilog.com
//		(change of type of requests, use of PE functions and sensitivity of response tread)  
//
//  Description : Transaction Level - Layer-1 example Master
//
// ============================================================================


#include "ocp_tl1_master.h"
#include "ocp_tl1_data_cl.h"

// ----------------------------------------------------------------------------
// Process : OCP_TL1_Master::OCP_TL1_Master
// 
// Constructor
// ----------------------------------------------------------------------------
template<class TdataCl_tl1> OCP_TL1_Master<TdataCl_tl1>::OCP_TL1_Master
      (
        sc_module_name name_
      , int ID
      , int Priority
      , double DelayPct
      )
        : sc_module         (name_)
        , MasterP           ("MasterPort")
        , m_ID              (ID)
        , m_Priority        (Priority)
        , m_DelayPct        (DelayPct)
{
  // InitParameters();

  SC_THREAD(MasterRequest);
  sensitive_pos(clk); 
  SC_THREAD(MasterResponse);
  sensitive<<MasterP; 
}

// ----------------------------------------------------------------------------
// Process : OCP_TL1_Master::~OCP_TL1_Master
// 
// Destructor
// ----------------------------------------------------------------------------
template<class TdataCl_tl1> OCP_TL1_Master<TdataCl_tl1>::~OCP_TL1_Master()
{
}


// ----------------------------------------------------------------------------
//  Method : OCP_TL1_Master::MasterRequest()
//
//  Top level request method of the Master
//
// ----------------------------------------------------------------------------
template<class TdataCl_tl1> void OCP_TL1_Master<TdataCl_tl1>::MasterRequest()
{
  int i = 0;
  int Pause[] = {0, 0, 0, 0}; // # of cycles between requests;
 // int Pause[] = {0, 1, 2, 3}; // # of cycles between requests;
  bool tmp = 0;
  Td Data = 0;
  Ta Addr = 0;
  int cnt = 0;

  while(true)
  {
    wait(); // wait for rising edge of clock

    if (cnt == 0)
    {
      // check if channel is free
      tmp = !MasterP->MgetSbusy();
      if (tmp)
      {
        // get new Pause value
        cnt = Pause[i%4]; i++;

        // Delay data signal for simulating physical signal delay
		// This must work with or without the next line
        // The delay must be less than 1 clk cycle
		//	if (m_DelayPct > 0)
        //  wait(TL_CLK_PERIOD * (m_DelayPct/100.0), TL_TIME_UNIT);

        // Put data into the channel
		m_DataCl->MputMAddr(Addr);
		m_DataCl->MputMData(Data);
		//begins by a WRITE burst
		if(Data<=10)   {
			m_DataCl->MputMCmd(OCP_MCMD_WR);
			
			//send 10 WRITE requests which are part of a burst
			if(Data<10)
				m_DataCl->MputMBurst(OCP_MBURST_CONT);
			//send last of burst request
			else if(Data==10)
				m_DataCl->MputMBurst(OCP_MBURST_LAST);

			MasterP->MputWriteRequest(); // Toggles the request data members	
		}
		//follows by a READ burst
		else if((Data>10) && (Data<=15)) {		
			m_DataCl->MputMCmd(OCP_MCMD_RD);

			//send 4 READ requests
			if(Data<=14)
				m_DataCl->MputMBurst(OCP_MBURST_CONT);
			//send last of burst request
			else if(Data==15)   {
				m_DataCl->MputMBurst(OCP_MBURST_LAST);
			}
			MasterP->MputReadRequest();	
		}
		else if(Data==16) {
			//one single READ request
			m_DataCl->MputMCmd(OCP_MCMD_RD);
			m_DataCl->MputMBurst(OCP_MBURST_LAST);
			MasterP->MputReadRequest();
		}
		else if(Data==17) {
			//one single WRITE request
			m_DataCl->MputMCmd(OCP_MCMD_WR);
			m_DataCl->MputMBurst(OCP_MBURST_LAST);
			MasterP->MputWriteRequest();
		}

		#ifdef DEBUG_G1
		  cout << "Master sent request "
			   << " delta " << simcontext()->delta_count()
			   << " time " << sc_time_stamp().to_seconds()
			   << " data " << Data << endl;
		#endif

		if(Data==17)
			  break;

		Addr += 4;
		//change address increment (5 instead of 4) at the 4th request
		if(Addr==12)
			Addr++;
		Data++;
      }  //end of test if channel is free
    } //enf of if cnt==0
    else
    {
      cnt--;
    }
  } // end of while loop
}


// ----------------------------------------------------------------------------
//  Method : OCP_TL1_Master::MasterResponse()
//
//  Top level response method of the Master
//
// ----------------------------------------------------------------------------
template<class TdataCl_tl1> void OCP_TL1_Master<TdataCl_tl1>::MasterResponse()
{
  Td Rdata;

  while(true)
  {
    wait(); 
    if (MasterP->MgetResponse(true))
    {
      m_DataCl->MgetSData(Rdata);

#ifdef DEBUG_G1
      cout << "Master got response "
           << " delta " << simcontext()->delta_count()
           << " time " << sc_time_stamp().to_seconds()
           << " data " << Rdata << endl;
#endif

    }

    //MasterP->Mrelease(); // release channel 
  } // end of while(true) loop
}


// ----------------------------------------------------------------------------
//  Method : OCP_TL1_Master::SputDirect()
//
//  Debug interface method.
//  Read/Write data, Slave to Master direction
//  Returns true for success and false for failure
//
// ----------------------------------------------------------------------------
template<class TdataCl_tl1> bool OCP_TL1_Master<TdataCl_tl1>::SputDirect(
         int SlaveID, bool IsWrite, Td *Data, Ta Address, int NumWords)

{
  // not implemented
  return(false);
}


// ----------------------------------------------------------------------------
//  Method : OCP_TL1_Master::end_of_elaboration()
//
//  This method is activated at the end of the elaboration phase
//  (when all binding operations are finished).
// ----------------------------------------------------------------------------
template<class TdataCl_tl1> void OCP_TL1_Master<TdataCl_tl1>::end_of_elaboration()
{
  sc_module::end_of_elaboration();

  // Initialize debug interface
  MasterP->MregisterDirectIF(this);

  // Get data structure
  m_DataCl = MasterP->GetDataCl();

  // Get communication structure
  m_CommCl = MasterP->GetCommCl();

  // Get system parameter structure
  m_ParamCl = MasterP->GetParamCl();

  // Put parameter into Channel
  // No parameters needed
}


// ----------------------------------------------------------------------------
//
//  Instantiation of the Master
//
// ----------------------------------------------------------------------------
template class OCP_TL1_Master<TL1_TEMPL_DATA_CL >; // see ocp_tl1_globals.h