// 
//  Copyright 2003 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG, OCP Transaction Level
//       Author : Norman Weyrich, Synopsys Inc., weyrich@synopsys.com
//                (modified by Joe Chou, Sonics Inc., joechou@sonicsinc.com)
//         Date : 03/25/2003
//
//  Description : Transaction Level - Layer-2 Slave example.
//
// ============================================================================

#ifndef _OCP_TL2_SLAVE_H
#define _OCP_TL2_SLAVE_H

#include "ocp_tl2_globals.h"
#include "ocp_tl2_data_cl.h"
#include "tl_slave_if.h"

#define TL_SLAVE_FIFO_DEPTH 8

template <class TdataCl> class OCP_TL2_Slave
  : public sc_module,
    public SdirectIF<TdataCl>
{
public:

  //
  typedef typename TdataCl::DataType Td;
  typedef typename TdataCl::AddrType Ta;

  //
  sc_port< TLslaveIF<TdataCl>, 1> SlaveP;

  //
  SC_HAS_PROCESS(OCP_TL2_Slave);

  // constructor
  OCP_TL2_Slave(sc_module_name name_, int ID, Ta StartAddress, Ta EndAddress,
    bool Pipelined = false, bool WriteResponse = true,
    int ReadAcceptCycles = 0, int WriteAcceptCycles = 0,
    int ReadResponseCycles = 0, int WriteResponseCycles = 0);

  // destructor
  ~OCP_TL2_Slave();

  // methods
  virtual bool MputDirect(int, bool, Td*, Ta, int);

  //
  void PrintTrans(int TaNum, Ta Addr, int NumWords, const char* Method);
  void PrintTime(const char* Pstring, int ID, Ta Addr);
  void PrintFuTime(const char* Pstring, int ID, Ta Addr, double AddTime);
  void Slave();
  void SlaveRequest();
  void SlaveResponse();

private:

  //
  void end_of_elaboration();

  // Pointer to the data structures of the channel
  TdataCl*          m_DataCl;
  ParamCl<TdataCl>* m_ParamCl;
  CommCl*           m_CommCl;

  // Slave parameters
  int  m_ID;
  Ta   m_StartAddress;
  Ta   m_EndAddress;
  bool m_Pipelined;
  bool m_WriteResponse;
  int  m_ReadAcceptCycles;
  int  m_WriteAcceptCycles;
  int  m_ReadResponseCycles;
  int  m_WriteResponseCycles;

  //
  int m_BusID;

  // Data arrays
  Td* m_SlaveMemory;

  // Constants
  int m_SmemoryLength;

  //
  Td*  m_Mdata[TL_SLAVE_FIFO_DEPTH];
  int  m_NumWords[TL_SLAVE_FIFO_DEPTH];
  int  m_NumBytesPerWord;
  Ta   m_Address[TL_SLAVE_FIFO_DEPTH];
  bool m_Write[TL_SLAVE_FIFO_DEPTH];
  int  m_MconnID[TL_SLAVE_FIFO_DEPTH];

  // Slave response
  OCPSRespType m_Sresp[TL_SLAVE_FIFO_DEPTH];

  // Request and response transaction numbers
  int m_ReqTaNum;
  int m_ResTaNum;

  // -------------------------
  // modelling pipelined delay
  // -------------------------
  // State to catch missed events
  bool     m_SlaveRespWait[TL_SLAVE_FIFO_DEPTH];

  //
  sc_time  m_RespStartTime[TL_SLAVE_FIFO_DEPTH];
  sc_event m_SlaveRespEvent;
};

#endif // _OCP_TL2_SLAVE_H
