/*****************************************************************************

  The following code is derived, directly or indirectly, from the SystemC
  source code Copyright (c) 1996-2003 by all Contributors.
  All Rights reserved.

  The contents of this file are subject to the restrictions and limitations
  set forth in the SystemC Open Source License Version 2.4 (the "License");
  You may not use this file except in compliance with such restrictions and
  limitations. You may obtain instructions on how to receive a copy of the
  License at http://www.systemc.org/. Software distributed by Contributors
  under the License is distributed on an "AS IS" basis, WITHOUT WARRANTY OF
  ANY KIND, either express or implied. See the License for the specific
  language governing rights and limitations under the License.

 *****************************************************************************/

/*****************************************************************************

  MODIFICATION LOG - modifiers, enter your name, affiliation, date and
  changes you are making here.

      Name, Affiliation, Date:
  Description of Modification:

 *****************************************************************************/

// ============================================================================
//      Project : Generic SystemC TL Communication Methodology
//       Author : Norman Weyrich, Synopsys Inc., weyrich@synopsys.com
//         Date : 11/15/2002
//
//  Description : Global defines
//
// ============================================================================

// File contains two parts: 
//   - Part 1 is generic (for all Layers) and therefore should be included
//     only ones (in a mixed Layer simulation)
//   - Part 2 is Layer specific                      

//------------------------------------
// Layer independent global definitions

#ifndef _TL_GLOBALS_H
#define _TL_GLOBALS_H

#include <stdio.h>
#include <stdlib.h>
#include <fstream.h>
#include <new>
#include "systemc.h"

#include "ocp_tl_param_cl.h"  // Parameter class, use only one per system
                           // If necessary merge all parameters into one class


const sc_time_unit TL_TIME_SCALE = SC_NS;        // clock period
const double TL_TIME_SCALE_SEC   = 0.000000001;

// Allowed Slave response values
const int TL_SRESP_OK    = 1;
const int TL_SRESP_ERROR = 3;


// Activation flag for timing output information
// #define DEBUG_M  // Master timing
// #define DEBUG_M1  // more Master timing
// #define DEBUG_B  // Bus timing
// #define DEBUG_S  // Slave timing
// #define DEBUG_S1 // Slave timing (response delay)
// #define DEBUG_C  // Channel timing
// #define TRACE_C    // Channel timing output into file
#define DEBUG_G1   // Output of request/response duration comming from
                   // Master, Bus, Slave modules

#endif // _TL_GLOBALS_H

//------------------------------------
// Layer-3 specific global definitions

#ifndef _TL3_GLOBALS_H
#define _TL3_GLOBALS_H

// maximum number of ATM cells sent in one burst
const int TL3_MAX_ATM_CELLS = 10;

// Number of transaction before simulation stops
// const int TL3_NUM_TA = 20000000;
const int TL3_NUM_TA = 100;

#include "atm_cell.h"

// Data class over which the modules are templatized
// The data class itself is templatized: DataCl<DataType, AddressType>
// DataType can be any e.g. int, sc_int<64>, sc_bigint<1024>,sc_bv<1024>,
// sc_lv<256>, ...
// AddressType must be either a native integer C++ type, or
// sc_int<>, sc_uint<>. E.g. int, long, sc_uint<64>, ...
#define TL3_TEMPL_DATA_CL TL3_DataCl<ATM_Cell, int >


#endif // _TL3_GLOBALS_H

