/* Copyright
 * ========================================================================================
 * Project:		Accurate DRAM Model
 * Author:		Nan Li, Yi Wang, KTH
 * ID:			adm.h, v1.0, 2011/05/09
 *
 * Description:	Top module of accruate DRAM model
 *
 * ========================================================================================
 * Version History
 * ========================================================================================
 * Version 1.0: Changed name from adm_model.h to adm.h
 * Version 0.1: Draft version
 * ========================================================================================
 */

#ifndef ADM_H_
#define ADM_H_

#include "adm_controller.h"
#include "adm_delay_submodel.h"
#include "adm_configuration.h"

#include "command_line.h"

template <unsigned int BUSWIDTH = 32>
class adm_model : public sc_module {
public:
	/* ports */
	sc_in_clk clk;
	ocpip::ocp_slave_socket_tl1<BUSWIDTH> ocpPort;

	/* DRAM configuration */
	adm_configuration admConfig;

	/* submodules */
	adm_controller<BUSWIDTH> controller;
	adm_delay_submodel delayModel;

	adm_model(const sc_module_name &nm, const char *ocpConfigFile, const char *admConfigFile)
			: sc_module(nm),
			  clk("clk"),
			  ocpPort("ocp_target_port"),
			  admConfig(admConfigFile),
			  controller("controller", admConfig),
			  delayModel("dram_delay", admConfig)
	{
		/* port bindings */
		ocpPort(controller.ocpPort);
		controller.clk(clk);
		controller.dramPort(delayModel.dram_delay_target_port);
		delayModel.clock(clk);
		delayModel.dram_delay_initiator_port(controller.ctrlPort);

		/* set OCP parameters */
		map_string_type  ocpParamMap;
		readMapFromFile(ocpConfigFile, ocpParamMap);
		ocpip::ocp_parameters params = create_ocp_configuration_from_map("sl", ocpParamMap);
		controller.ocpPort.set_ocp_config(params);
	}
};


#endif /* ADM_MODEL_H_ */
