/*****************************************************************************

  The following code is derived, directly or indirectly, from the SystemC
  source code Copyright (c) 1996-2001 by all Contributors.
  All Rights reserved.

  The contents of this file are subject to the restrictions and limitations
  set forth in the SystemC Open Source License Version 2.2 (the "License");
  You may not use this file except in compliance with such restrictions and
  limitations. You may obtain instructions on how to receive a copy of the
  License at http://www.systemc.org/. Software distributed by Contributors
  under the License is distributed on an "AS IS" basis, WITHOUT WARRANTY OF
  ANY KIND, either express or implied. See the License for the specific
  language governing rights and limitations under the License.

 *****************************************************************************/

/*****************************************************************************

  sc_module_registry.cpp -- Registry for all modules.
                            FOR INTERNAL USE ONLY.

  Original Author: Martin Janssen, Synopsys, Inc., 2001-05-21

 *****************************************************************************/

/*****************************************************************************

  MODIFICATION LOG - modifiers, enter your name, affiliation, date and
  changes you are making here.

      Name, Affiliation, Date:
  Description of Modification:

 *****************************************************************************/


#include "systemc/kernel/sc_module.h"
#include "systemc/kernel/sc_module_registry.h"
#include "systemc/kernel/sc_simcontext.h"
#include "systemc/utils/sc_exception.h"


// ----------------------------------------------------------------------------
//  CLASS : sc_module_registry
//
//  Registry for all modules.
//  FOR INTERNAL USE ONLY!
// ----------------------------------------------------------------------------

void
sc_module_registry::insert( sc_module& module_ )
{
    if( m_simc->is_running() ) {
	REPORT_ERROR( 7061, "simulation running" );
    }

#ifdef DEBUG_SYSTEMC
    // check if module_ is already inserted
    for( int i = size() - 1; i >= 0; -- i ) {
	if( &module_ == m_module_vec[i] ) {
	    REPORT_ERROR( 7061, "already inserted" );
	}
    }
#endif

    // insert
    m_module_vec.push_back( &module_ );
}

void
sc_module_registry::remove( sc_module& module_ )
{
    int i;
    for( i = 0; i < size(); ++ i ) {
	if( &module_ == m_module_vec[i] ) {
	    break;
	}
    }
    if( i == size() ) {
	REPORT_ERROR( 7062, "" );
    }

    // remove
    m_module_vec[i] = m_module_vec[size() - 1];
    m_module_vec.decr_count();
}


// constructor

sc_module_registry::sc_module_registry( sc_simcontext& simc_ )
: m_simc( &simc_ )
{}


// destructor

sc_module_registry::~sc_module_registry()
{}


// called when elaboration is done

void
sc_module_registry::elaboration_done()
{
    bool error = false;
    for( int i = 0; i < size(); ++ i ) {
	m_module_vec[i]->elaboration_done( error );
    }
}


// Taf!
