/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

#ifndef TEST_REPORT_HANDLER_H_
#define TEST_REPORT_HANDLER_H_

#include "test_macros.h"

// test utilities in dedicated namespace
// to avoid conflict with local definitions in tests
namespace test_util {

void report_handler( const sc_core::sc_report& rep,
                     const sc_core::sc_actions& actions)
{
  if (rep.get_severity() == sc_core::SC_ERROR)
  {
    std::cout << "expected error occurred" << std::endl;
    TEST_LABEL_END;
    exit(0); // stop executable
    // sc_core::sc_stop(); // this gives this additional message SystemC simulation stopped by user
  }

  if (rep.get_severity() == sc_core::SC_WARNING)
  {
      std::cout << "expected warning occurred" << std::endl;
      TEST_LABEL_END;
      exit(0); // stop executable
      // sc_core::sc_stop(); // this gives this additional message SystemC simulation stopped by user
  }

  // redirect other errors to the default_handler
  std::cout << "unexpected error or warning occurred" << std::endl;
  sc_core::sc_report_handler::default_handler(rep, actions);
  exit(0); // stop executable
}

} // namespace test_util

#endif // TEST_REPORT_HANDLER_H_
