/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test if a TDF output port can be used to for AC noise analysis

#include <systemc-ams>
#include "test_utilities.h"

SCA_TDF_MODULE( mod_a )
{
  sca_tdf::sca_out<double> out; // output port

  void set_attributes()
  {
    set_timestep(1.0, sc_core::SC_MS);
  }

  void processing() {}

  void ac_processing()
  {
    sca_ac_analysis::sca_ac_noise(out) = 1.0;
  }

  SCA_CTOR(mod_a) : out("out") {}
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sca_tdf::sca_signal<double> sig1;

  mod_a a("a");
    a(sig1);

  sca_eln::sca_node     n1("n1"), n2("n2"), n3("n3");
  sca_eln::sca_node_ref gnd("gnd");

  sca_eln::sca_tdf_vsource vin("vin");
    vin.inp(sig1);
    vin.p(n1);
    vin.n(gnd);

  sca_eln::sca_r r1("r1");
    r1.p(n1);
    r1.n(n2);
    r1.value = 1.0e3;

  sca_eln::sca_c c1("c1");
    c1.p(n2);
    c1.n(n3);
    c1.value = 1e-7;

  sca_eln::sca_vsource v1("v1");
    v1.p(n3);
    v1.n(gnd);
    v1.ac_noise_amplitude = 5.0;

  sca_util::sca_trace_file* tf;
  tf = sca_util::sca_create_tabular_trace_file("ac_noise_trace.dat");

  tf->set_mode(sca_util::sca_ac_format(sca_util::SCA_AC_DB_DEG));
  tf->set_mode(sca_util::sca_noise_format(sca_util::SCA_NOISE_ALL));

  sca_util::sca_trace(tf, sig1, "sig1");
  sca_util::sca_trace(tf, n1, "n1");
  sca_util::sca_trace(tf, n2, "n2");
  sca_util::sca_trace(tf, n3, "n3");

  sca_ac_analysis::sca_ac_noise_start(1.0, 1e6, 1000, sca_ac_analysis::SCA_LOG);

  sca_util::sca_close_tabular_trace_file(tf);

  std::cout << "Check noise frequency domain results..." << std::endl;

  test_util::check_results("ac_noise_trace", 20, "test03", 1e-3, 1e-5);

  TEST_LABEL_END;

  return 0;
}
