/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// derived from problem reported at
// http://forums.accellera.org/topic/6041-large-system-simulation-problem/

#include <systemc-ams>
#include <systemc>
#include <iostream>
#include "test_utilities.h"

///////////////////////////////////////////////////////////////////////////////

template<int N=1024>
SC_MODULE(rmatnn) {
  sc_core::sc_in<double>        name1 {"name1"};
  sca_eln::sca_de_vsource       i_sca_de_vsource1 {"i_sca_de_vsource1"};
  sca_eln::sca_node_ref         i_gnd1 {"i_gnd1"}; // gnd
  sca_eln::sca_node_ref         i_gnd2 {"i_gnd2"};
  sca_eln::sca_node             unnamedNet1 {"unnamedNet1"};
  sc_core::sc_vector<sca_eln::sca_node> c_vec { "c_vec", N }; //nodes between resistors
  sc_core::sc_vector<sca_eln::sca_r>    rs_vec { "rs_vec", N };

  SC_CTOR(rmatnn)
  {
    i_sca_de_vsource1.set_timestep(1.0, sc_core::SC_NS);
    i_sca_de_vsource1.inp(name1);
    i_sca_de_vsource1.n(i_gnd1);
    i_sca_de_vsource1.p(unnamedNet1);
    rs_vec[0].p(unnamedNet1); // connect  source to first resistor
    rs_vec[0].n(c_vec[0]);    // connect n port of first resistor to node 0
    rs_vec[0].value = 10;

    for (int i = 1; i < N - 1; i++) {
      rs_vec[i].p(c_vec[i - 1]);
      rs_vec[i].n(c_vec[i]);
      rs_vec[i].value = 10;
    }
    rs_vec[N - 1].p(c_vec[N - 2]);
    rs_vec[N - 1].n(i_gnd2);
    rs_vec[N - 1].value = 10;
  }
};

int sc_main(int argc, char* argv[])
{
  TEST_LABEL_START;

  rmatnn<20000> cir("rmatnn");
  sc_core::sc_signal<double> sig1 ("sig1");
  cir.name1(sig1);

  sc_core::sc_start(2.0, sc_core::SC_US);

  TEST_LABEL_END;

  return (EXIT_SUCCESS);
}
