/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test if sca_core::sca_module is derived from sc_core::sc_module and return kind

#include <systemc-ams>
#include "test_utilities.h"

// FIXME: officially not allowed to derive from this base class
class my_module : public sca_core::sca_module
{
public:
  SCA_CTOR(my_module)
  {
    std::cout << "constructor: my_module" << std::endl;
  }
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sc_core::sc_module* mymodule1 = new my_module("mymodule1");

  std::cout << "my_module: ";
  std::cout << mymodule1->kind() << std::endl;

  TEST_LABEL_END;

  delete mymodule1;
  
  return 0;
}
