/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// user's guide example my_dut as part of time-domain simulation example
// (extracted from my_dga.cpp)

#include <systemc-ams>

 
SCA_TDF_MODULE(my_dut)
{    
  sca_tdf::sca_in<double>   in; // input port
  sca_tdf::sca_out<double> out; // output port

  // control signal from the discrete-event domain
  sca_tdf::sca_de::sca_in<bool> ctrl; // input converter port

  SCA_CTOR(my_dut) : in("in"), out("out"), ctrl("ctrl"),
    high_gain(100.0), low_gain(1.0) {}

  void processing()
  {
    double gain = ctrl.read() ? high_gain : low_gain; 
    out.write( gain * in.read() );
  } 

 private:
  double high_gain, low_gain;      
};
  
