/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// my_mixed_module example from user's guide

#include <systemc-ams>
#include "test_utilities.h"

SCA_TDF_MODULE( mod_c )
{
  sca_tdf::sca_de::sca_in<double> in1;
  sca_tdf::sca_de::sca_in<double> in2;
  sca_tdf::sca_de::sca_out<bool> out1;
  sca_tdf::sca_out<double> out2;
  
  SCA_CTOR( mod_c ) : in1("in1"), in2("in2"), out1("out1"), out2("out2") {}

  void set_attributes()
  {
    set_timestep(1.0, sc_core::SC_MS);
  }
  
  void processing()
  {
    out1.write(false);
    out2.write(false);
  }
};  

SCA_TDF_MODULE( mod_d )
{
  sca_tdf::sca_in<double> in1;
  sca_tdf::sca_de::sca_in<bool> in2;
  sca_tdf::sca_de::sca_out<double> out;

  SCA_CTOR( mod_d ) : in1("in1"), in2("in2"), out("out") {}

  void processing()
  {
    out = 0.0;
  }
};

SC_MODULE( mod_e )
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;

  SC_CTOR( mod_e ) : in("in"), out("out")
  {
    out.initialize(false);
  }
};

SC_MODULE( mod_x )
{
  sc_core::sc_out<double> out;

  SC_CTOR( mod_x ) : out("out")
  {
    out.initialize(0.0);
  }

};

SC_MODULE( mod_y )
{
  sc_core::sc_in<double> in;

  SC_CTOR( mod_y ) : in("in") {}

};

SC_MODULE(my_mixed_module)
{
  sc_core::sc_in<double> in;
  sc_core::sc_out<double> out;

  mod_c c; // TDF primitive module
  mod_d d; // TDF primitive module
  mod_e e; // SystemC module
  
  SC_CTOR(my_mixed_module)
  : in("in"), out("out"), c("c"), d("d"), e("e"),
    sig("sig"), sc_sig1("sc_sig1"), sc_sig2("sc_sig2")
  {
    c.in1(in);
    c.in2(out);
    c.out1(sc_sig1);
    c.out2(sig);

    d.in1(sig);
    d.in2(sc_sig2);
    d.out(out);

    e.in(sc_sig1);
    e.out(sc_sig2);
  }

 private:
  sca_tdf::sca_signal<double> sig;
  sc_core::sc_signal<bool> sc_sig1;
  sc_core::sc_signal<bool> sc_sig2;
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sc_core::sc_signal<double> sig1;
  sc_core::sc_signal<double> sig2;

  mod_x x("x");
    x.out(sig1);
  
  my_mixed_module dut("dut");
    dut.in(sig1);
    dut.out(sig2);

  mod_y y("y");
    y.in(sig2);
  
  sc_core::sc_start(3, sc_core::SC_MS);
  
  TEST_LABEL_END;
    
  return 0;
}
