/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test use of ac_processing method

#include <systemc-ams>
#include "test_utilities.h"

class tdf_module_base : public sca_tdf::sca_module
{
 public:

  virtual void set_attributes() {}

  virtual void initialize() {}

  virtual void my_ac_processing() {}

  tdf_module_base()
  {
    ptr = static_cast<sca_module_method>(&tdf_module_base::my_ac_processing);
    register_ac_processing( ptr );
  }

 private:
  sca_module_method ptr; // pointer to new method
};

class mod_a : public tdf_module_base
{
 public:
  sca_tdf::sca_out<double> out;

  void set_attributes()
  {
    set_timestep(1.0, sc_core::SC_MS);
  }

  void processing() {}

  void my_ac_processing()
  {
    sca_ac_analysis::sca_ac(out);
  }

  mod_a( sc_core::sc_module_name ) {}
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sca_tdf::sca_signal<double> sig1;

  mod_a a("a");
    a(sig1);

  sca_ac_analysis::sca_ac_start(10.0, 100.0, 11, sca_ac_analysis::SCA_LOG);

  TEST_LABEL_END;

  return 0;
}
