/*
 * Copyright (C) 2014 Torsten Maehne, Universit Pierre et Marie Curie
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
//
// PROJECT NAME: vibration_sensor_dvcon14
//
// LIBRARY NAME: frontend
//
// MODULE NAME:  gain_controller
//
// DESCRIPTION OF MODULE:
//      Gain Controller
//
// DESCRIPTION OF PORTS:           (please see header)
// DESCRIPTION OF PARAMETER:       (please see header)
//
// this file was generated by 'sca_xml2cpp.xsl' StyleSheet
//
////////////////////////////////////////////////////////////////////////////////
//
//   Version Id       : $Id$
//   Author           : karsten
//   Last Modified By : $Author$
//   Last Modified On : $Date$
//
////////////////////////////////////////////////////////////////////////////////

#ifndef _VIBRATION_SENSOR_DVCON14_FRONTEND_GAIN_CONTROLLER_H_
#include "gain_controller.h"
#define FHG_INCLUDE_IMPLEMENTATION
#endif

namespace vibration_sensor_namespace
{

enum state_type {keep_gain, increase_gain, decrease_gain};


//-------------------------------------------------------------------//
// states                                                            //
//-------------------------------------------------------------------//
struct gain_controller::states
{
	state_type state;            // Current state.
	int k;

	long avr_sum;
	long avr_sample_cnt;
	sc_core::sc_signal<long> avr_result;


	sc_core::sc_event calc_gain_ev;

    states()
    {
    	state=keep_gain;
    	avr_sum=0;
    	avr_sample_cnt=0;
    	avr_result=0;
    }

};
//-------------------------------------------------------------------//

#ifdef FHG_INCLUDE_IMPLEMENTATION


//-------------------------------------------------------------------//
gain_controller::states& gain_controller::create_states() { return *(new states); }
//-------------------------------------------------------------------//


//////////////////////////////////////////////
// USER_METHOD state_init
//////////////////////////////////////////////
void gain_controller::state_init()
{
	s.k=p.k_0;
}


//////////////////////////////////////////////
// SC_METHOD adapt_gain
//////////////////////////////////////////////
void gain_controller::abs_ampl_avr()
{
	s.avr_sum += std::labs(amp_in.read());

	s.avr_sample_cnt++;

	if(s.avr_sample_cnt>=p.n_samples_avr)
	{
		s.avr_result=s.avr_sum/p.n_samples_avr;
		s.avr_sum=0;
		s.avr_sample_cnt=0;

		s.calc_gain_ev.notify();
	}
}

//////////////////////////////////////////////
// SC_METHOD adapt_gain
//////////////////////////////////////////////
void gain_controller::adapt_gain()
{
	double avr=s.avr_result.read();

	switch (s.state)
	{
	case keep_gain:
		if (avr < p.low_threshold)
		{
			s.state = increase_gain;
			++s.k;
		}
		else if (avr >= p.high_threshold)
		{
			s.state = decrease_gain;
			--s.k;
		}
		break;
	case increase_gain:
		if (avr < p.high_threshold)
		{
			++s.k;
		}
		else
		{
			s.state = decrease_gain;
			--s.k;
		}
		break;
	case decrease_gain:
		if (avr < p.high_threshold)
		{
			s.state = keep_gain;
		}
		else
		{
			--s.k;
		}
		break;
	default:
		SC_REPORT_ERROR("/vibration_sensor/gain_controller",
				"Unexpected state.");
	}
	// Limit and set new gain.
	if (s.k < p.k_min)
	{
		s.k = p.k_min;
	}
	if (s.k > p.k_max)
	{
		s.k = p.k_max;
	}
	k_out.write(s.k);

	next_trigger(s.calc_gain_ev);

}


#endif //#ifdef FHG_INCLUDE_IMPLEMENTATION

}  //end namespace vibration_sensor_dvcon14_namespace

//clear temporary defines
#undef FHG_INCLUDE_IMPLEMENTATION

