/*
 * Copyright (C) 2014 Torsten Maehne, Universit Pierre et Marie Curie
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// PROJECT NAME: vibration_sensor_dvcon14
//
// LIBRARY NAME: frontend
//
// MODULE NAME:  pga
//
// DESCRIPTION OF MODULE:
//      programmable gain amplifier
//
// DESCRIPTION OF PORTS:           (please see header)
// DESCRIPTION OF PARAMETER:       (please see header)
//
// this file was generated by 'sca_xml2cpp.xsl' StyleSheet
//
////////////////////////////////////////////////////////////////////////////////
//
//   Version Id       : $Id$
//   Author           : karsten
//   Last Modified By : $Author$
//   Last Modified On : $Date$
//
////////////////////////////////////////////////////////////////////////////////

#ifndef _VIBRATION_SENSOR_DVCON14_FRONTEND_PGA_H_
#include "pga.h"
#define FHG_INCLUDE_IMPLEMENTATION
#endif

namespace vibration_sensor_namespace
{

//-------------------------------------------------------------------//
// states                                                            //
//-------------------------------------------------------------------//
struct pga::states
{

    states()
    {
    }

};
//-------------------------------------------------------------------//

#ifdef FHG_INCLUDE_IMPLEMENTATION


//-------------------------------------------------------------------//
pga::states& pga::create_states() { return *(new states); }
//-------------------------------------------------------------------//


//////////////////////////////////////////////
// method initialize                        //
//////////////////////////////////////////////
void pga::initialize()
{
	sc_assert(p.v_supply > 0.0);
}

//////////////////////////////////////////////
// method processing                        //
//////////////////////////////////////////////
void pga::processing()
{
	 double k = k_in.read();

	  // Amplify input value to output value.
	  double val = std::pow(2.0, k) * in.read();

	  // Test if output saturates.
	  if (val > p.v_supply)
	  {
	    out.write(p.v_supply);
	  }
	  else if (val < -p.v_supply)
	  {
	    out.write(-p.v_supply);
	  }
	  else
	  {
	    out.write(val);
	  }
}



#endif //#ifdef FHG_INCLUDE_IMPLEMENTATION

}  //end namespace vibration_sensor_dvcon14_namespace

//clear temporary defines
#undef FHG_INCLUDE_IMPLEMENTATION

