/*
 * Copyright (C) 2014 Torsten Maehne, Universit Pierre et Marie Curie
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
//
// PROJECT NAME: vibration_sensor_dvcon14
//
// LIBRARY NAME: source
//
// MODULE NAME:  vibration_src
//
// DESCRIPTION OF MODULE:
//      Waveform generator module to output a sequence of sinusoidal wavelets
//
// DESCRIPTION OF PORTS:           (please see header)
// DESCRIPTION OF PARAMETER:       (please see header)
//
// this file was generated by 'sca_xml2cpp.xsl' StyleSheet
//
////////////////////////////////////////////////////////////////////////////////
//
//   Version Id       : $Id$
//   Author           : karsten
//   Last Modified By : $Author$
//   Last Modified On : $Date$
//
////////////////////////////////////////////////////////////////////////////////

#ifndef _VIBRATION_SENSOR_DVCON14_SOURCE_VIBRATION_SRC_H_
#include "vibration_src.h"
#define FHG_INCLUDE_IMPLEMENTATION
#endif

namespace vibration_sensor_namespace
{

//-------------------------------------------------------------------//
// states                                                            //
//-------------------------------------------------------------------//
struct vibration_src::states
{
    double  T_0;
    double  T_period;


    states()
    {
    	T_0=0.0;
    	T_period=0.0;
    }

};
//-------------------------------------------------------------------//

#ifdef FHG_INCLUDE_IMPLEMENTATION


//-------------------------------------------------------------------//
vibration_src::states& vibration_src::create_states() { return *(new states); }
//-------------------------------------------------------------------//


//////////////////////////////////////////////
// method initialize                        //
//////////////////////////////////////////////
void vibration_src::initialize()
{
    assert(p.f_0 > 0.0);
    assert(p.n_period >= 1);
    assert(p.n_harmonic >= 0);

    s.T_0= 1.0 / p.f_0;
    s.T_period=p.n_period * s.T_0;
}

//////////////////////////////////////////////
// method processing                        //
//////////////////////////////////////////////
void vibration_src::processing()
{
    double t = this->get_time().to_seconds();
    double t_pos = fmod(t, s.T_period);

    int harmonic = static_cast<int>(floor(t / s.T_period)) % (p.n_harmonic + 1);

    double val = p.offset;

    // val += pow(2.0, harmonic) * amplitude_ * sin(2.0 * M_PI * pow(2.0, harmonic) * f_0_ * t_pos);
    val += p.amplitude * sin(2.0 * M_PI * pow(2.0, harmonic) * p.f_0 * t_pos);

    out.write(val);

}



#endif //#ifdef FHG_INCLUDE_IMPLEMENTATION

}  //end namespace vibration_sensor_dvcon14_namespace

//clear temporary defines
#undef FHG_INCLUDE_IMPLEMENTATION

