`include "WORKAROUND.svh"

import apb_pkg::*;

module apb_bridge ( apb_if.slave master,
		    // LRM team: Add a system call $num(SLAVE_e) instead of SLAVE_NUM below?
		    // Even better if SV has the ability to define the index of an array
		    // as an enum type - this way the enum index would show up in waves with
		    // descriptive text.
		    apb_if.master slave[SLAVE_NUM] );

    import other_pkg::*;

`ifdef WORKAROUND_interface_array_size
    logic sel [SLAVE_NUM];
`else
    logic sel [$size(slave)];
`endif
    always_comb begin
        if ( ~master.sel )
            sel = '{ default: 0 };
        else begin
            sel[SLAVE_TEMPS]    = master.req.addr
                inside { [REG_TEMP_JAN:REG_TEMP_DEC] };
            sel[SLAVE_BD_MONTH] = master.req.addr
                inside { REG_BD_MONTH_MOM, REG_BD_MONTH_DAD,
                         REG_BD_MONTH_DAUGHTER, REG_BD_MONTH_SON };
            sel[SLAVE_DAY_MASK] = master.req.addr == REG_DAY_MASK;
        end
    end

`ifdef WORKAROUND_unpacked_array_method
 `ifdef WORKAROUND_interface_array_size
    apb_resp_s [SLAVE_NUM-1:0] resp;
 `else
    apb_resp_s [$size(slave)-1:0] resp;
 `endif
`else
    apb_resp_s resp [$size(slave)];
`endif

    // LRM team, why not foreach with generate?
`ifdef WORKAROUND_interface_array_size
    for ( genvar i = 0; i < SLAVE_NUM; i++ ) begin : gen_select
`else
    for ( genvar i = 0; i < $size(slave); i++ ) begin : gen_select
`endif
        always_comb begin
            slave[i].sel  = sel[i];
            slave[i].req  = sel[i] ? master.req
                                   : '{ addr: apb_addr_e'(0), default: 0 };
	    resp[i] = slave[i].resp;
        end
    end

`ifdef WORKAROUND_unpacked_array_method
    array_or #( .OR_t(apb_resp_s), .NUM($size(resp)) ) bus_or
              ( .in(resp), .out(master.resp) );
`elsif WORKAROUND_assign_unpacked_array_method
    always_comb master.resp = resp.or;
`else
    assign master.resp = resp.or;
`endif

endmodule
